#!/bin/bash

# Make simulations of fixed sizes : 10M reads total at ratios 1:5, 1:10, 1:20, 1:100, 0:1

numsimulation=$1

cctfastq="FASTQnames/trainingCCT.fq.names.gz"
lctfastq="FASTQnames/trainingLCT.fq.names.gz"
ncpfastq="FASTQnames/trainingNCP.fq.names.gz"

cctbam="BAMfiles/merged.CCT.bam"
lctbam="BAMfiles/merged.LCT.bam"
ncpbam="BAMfiles/merged.50NCP.bam"


allcpgs="./scripts/Methylation_Haplotype_Analysis/allcpg/hg19.fa.allcpgs.txt"

mkdir -p Simulated

mkdir -p "LCT_simulation"
mkdir -p "CCT_simulation"
mkdir -p "NCP_simulation"

echo -e "minFraction\tforeground\tbackground" > cct.hapinfo.list_$numsimulation
echo -e "minFraction\tforeground\tbackground" > lct.hapinfo.list_$numsimulation
echo "" > NCP_simulation/empty.hapinfo.txt

for i in `seq 1 1 $numsimulation`
do

  # 0:1 cancer to  normal ratio
  outprefix="NCP.10M.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $ncpfastq $ncpbam 10000000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam NCP_simulation/${outprefix}

  echo -e "0.00\tNCP_simulation/${outprefix}.bam.cgPE.hapinfo.txt\tNCP_simulation/empty.hapinfo.txt" >> cct.hapinfo.list_$numsimulation
  echo -e "0.00\tNCP_simulation/${outprefix}.bam.cgPE.hapinfo.txt\tNCP_simulation/empty.hapinfo.txt" >> lct.hapinfo.list_$numsimulation

  # 1:100 cancer to normal ratio
  outprefix="NCP.9900K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $ncpfastq $ncpbam 9900000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam NCP_simulation/${outprefix}

  outprefix="CCT.100K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $cctfastq $cctbam 100000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam CCT_simulation/${outprefix}

  outprefix="LCT.100K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $lctfastq $lctbam 100000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam LCT_simulation/${outprefix}

  echo -e "0.01\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tCCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> cct.hapinfo.list_$numsimulation
  echo -e "0.01\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tLCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> lct.hapinfo.list_$numsimulation

  # 1:20 cancer to normal ratio
  outprefix="NCP.9500K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $ncpfastq $ncpbam 9500000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam NCP_simulation/${outprefix}

  outprefix="CCT.500K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $cctfastq $cctbam 500000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam CCT_simulation/${outprefix}

  outprefix="LCT.500K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $lctfastq $lctbam 500000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam LCT_simulation/${outprefix}

  echo -e "0.05\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tCCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> cct.hapinfo.list_$numsimulation
  echo -e "0.05\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tLCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> lct.hapinfo.list_$numsimulation

  # 1:10 cancer to normal ratio
  outprefix="NCP.9000K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $ncpfastq $ncpbam 9000000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam NCP_simulation/${outprefix}

  outprefix="CCT.1000K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $cctfastq $cctbam 1000000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam CCT_simulation/${outprefix}

  outprefix="LCT.1000K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $lctfastq $lctbam 1000000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam LCT_simulation/${outprefix}

  echo -e "0.10\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tCCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> cct.hapinfo.list_$numsimulation
  echo -e "0.10\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tLCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> lct.hapinfo.list_$numsimulation

  # 1:5 cancer to normal ratio
  outprefix="NCP.8000K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $ncpfastq $ncpbam 8000000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam NCP_simulation/${outprefix}

  outprefix="CCT.2000K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $cctfastq $cctbam 2000000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam CCT_simulation/${outprefix}

  outprefix="LCT.2000K.$RANDOM"
  perl ./scripts/sample_reads_from_fqnames.pl $lctfastq $lctbam 2000000 > Simulated/${outprefix}.sam
  samtools view -Sb -t /media/3TB_AG/bisHg19/hg19.fa.fai Simulated/${outprefix}.sam > Simulated/${outprefix}.bam
  ./scripts/Methylation_Haplotype_Analysis/scripts/MethylationHaplotypeGenerator_V2.sh $allcpgs Simulated/${outprefix}.bam LCT_simulation/${outprefix}

  echo -e "0.20\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tCCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> cct.hapinfo.list_$numsimulation
  echo -e "0.20\tNCP_simulation/${outprefix}.cgPE.hapinfo.txt\tLCT_simulation/${outprefix}.cgPE.hapinfo.txt" >> lct.hapinfo.list_$numsimulation

done
